<?php

namespace App\Services;

use App\Models\AssignedLock;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\Log;


use Carbon\Carbon;

use App\Models\ScienerDetails;
use App\Models\DoorTiming;

class ScienerApiService
{
    protected $baseUrl;
    protected $clientId;
    protected $clientSecret;

    // Variable to show status messages

    public $message;
    public $error;

    public $showSuccessMessage = false;
    public $showErrorMessage = false;

    protected $listeners = ['resetMessageFlags' => 'resetMessageState'];

    public function __construct()
    {
        $this->baseUrl = config('services.sciener.base_url');
        $this->clientId = config('services.sciener.client_id');
        $this->clientSecret = config('services.sciener.client_secret');
    }

    /**
     * Get the access token using username and password.
     *
     * @param string $username
     * @param string $password
     * @return array
     */
    public function getAccessToken($username, $password)
    {
        $response = Http::asForm()->post($this->baseUrl . 'oauth2/token', [
            'clientId' => $this->clientId,
            'clientSecret' => $this->clientSecret,
            'username' => $username,
            'password' => md5($password)  // Encrypt the password using MD5 as per the documentation
        ]);

        return $response;
    }

    public function refresh_ScienerToken($refreshToken)
    {
        $response = Http::asForm()->post($this->baseUrl . 'oauth2/token', [
            'clientId' => $this->clientId,
            'clientSecret' => $this->clientSecret,
            'grant_type' => "refresh_token",
            'refresh_token' => $refreshToken  // Encrypt the password using MD5 as per the documentation
        ]);

        $data = $response->json();

        $accessToken = $data['access_token'] ?? null;
        $expiresIn = $data['expires_in'] ?? null;
        $refreshToken = $data['refresh_token'] ?? null;

        if (isset($response['access_token'])) {
            $scienerDetails = new ScienerDetails();
            $scienerDetails->token = $response['access_token'];
            $scienerDetails->refresh_token = $response['refresh_token'];
            $scienerDetails->save(); // Save the updated tokens

        }
        return $response->json();
    }

    /**
     * Get the list of locks for a user.
     *
     * @param string $accessToken
     * @param int $pageNo
     * @param int $pageSize
     * @param string|null $lockAlias
     * @param int|null $groupId
     * @return array
     */
    public function getLockList($accessToken, $pageNo = 1, $pageSize = 100)
    {
        // Try to get the lock data from the cache
        $locks = Cache::get('lock_data');

        // If the data isn't in the cache, fetch it and store it in the cache
        if (!$locks) {
            $params = [
                'clientId' => $this->clientId,
                'accessToken' => $accessToken,
                'pageNo' => $pageNo,
                'pageSize' => $pageSize,
                'date' => now()->timestamp * 1000  // Current timestamp in milliseconds
            ];

            $response = Http::get($this->baseUrl . 'v3/key/list', $params);
            $locks = $response->json();

            // Store the data in the cache for 10 minutes
            Cache::put('lock_data', $locks, 30); // 600 seconds = 10 minutes
        }
        return $locks;
    }

    public function get_propertyLockList($accessToken, $pageNo = 1, $pageSize = 100)
    {

        // If the data isn't in the cache, fetch it and store it in the cache
        $params = [
            'clientId' => $this->clientId,
            'accessToken' => $accessToken,
            'pageNo' => $pageNo,
            'pageSize' => $pageSize,
            'date' => now()->timestamp * 1000  // Current timestamp in milliseconds
        ];

        $response = Http::get($this->baseUrl . 'v3/key/list', $params);
        $locks = $response->json();

        // Store the data in the cache for 10 minutes

        return $locks;
    }

    public function unlockLock($accessToken, $lockId)
    {
        $params = [
            'clientId' => $this->clientId,
            'accessToken' => $accessToken,
            'lockId' => $lockId,
            'date' => now()->timestamp * 1000
        ];

        $response = Http::post($this->baseUrl . 'v3/lock/unlock?' . http_build_query($params));
        return $response->json();
    }
    public function getLockDetails($accessToken, $lockId)
    {
        // Assuming the API endpoint to fetch a specific lock's details is 'v3/lock/detail'
        $params = [
            'clientId' => $this->clientId,
            'accessToken' => $accessToken,
            'lockId' => $lockId,
            'date' => now()->timestamp * 1000
        ];

        $response = Http::get($this->baseUrl . 'v3/key/get', $params);
        return $response->json();
    }
    /**
     * Get all created passcodes of a lock.
     *
     * @param string $accessToken
     * @param int $lockId
     * @param int $pageNo
     * @param int $pageSize
     * @return array
     */
    public function listKeyboardPwd($accessToken, $lockId)
    {
        $params = [
            'clientId' => $this->clientId,
            'accessToken' => $accessToken,
            'lockId' => $lockId,
            'pageNo' => 1, // You can adjust this as needed
            'pageSize' => 100, // You can adjust this as needed
            'date' => now()->timestamp * 1000
        ];
        $timeoutSeconds = 24000;
        $response = Http::timeout($timeoutSeconds)->get($this->baseUrl . 'v3/lock/listKeyboardPwd', $params);
        return $response->json();
    }
    public function getUnlockRecords($accessToken, $lockId, $pageSize = 20)
    {
        $params = [
            'clientId' => $this->clientId,
            'accessToken' => $accessToken,
            'lockId' => $lockId,
            'pageNo' => 1,
            'pageSize' => $pageSize,
            'date' => now()->timestamp * 1000
        ];

        $response = Http::get('https://euapi.sciener.com/v3/lockRecord/list', $params);
        return $response->json();
    }
    // Inside ScienerApiService.php

    public function getPassageModeConfig($lockId, $accessToken)
    {
        $params = [
            'clientId' => $this->clientId,
            'accessToken' => $accessToken,
            'lockId' => $lockId,
            'date' => now()->timestamp * 1000 // Current time in milliseconds
        ];

        $response = Http::get($this->baseUrl . 'v3/lock/getPassageModeConfig', $params);
        return $response->json();
    }

    public function setPassageMode($lockId, $accessToken, $data)
    {
        $params = array_merge([
            'clientId' => $this->clientId,
            'accessToken' => $accessToken,
            'lockId' => $lockId,
            'type' => 2, // via gateway or WiFi lock
            'date' => now()->timestamp * 1000 // Current time in milliseconds
        ], $data);

        $response = Http::post($this->baseUrl . 'v3/lock/configPassageMode', $params);
        return $response->json();
    }
    public function initializeLock($accessToken, $lockData, $lockAlias)
    {
        $params = [
            // Parameters as required by the API
            'clientId' => $this->clientId,
            'accessToken' => $accessToken,
            'lockData' => $lockData,
            'lockAlias' => $lockAlias,
            'date' => now()->timestamp * 1000,
        ];

        $response = Http::asForm()->post($this->baseUrl . 'v3/lock/initialize', $params);

        return $response->json();
    }


    public function delete_Passcode($accessToken, $lockId, $keyboardPwdId)
    {
        $params = [
            // Parameters as required by the API
            'clientId' => $this->clientId,
            'accessToken' => $accessToken,
            'lockId' => $lockId,
            'keyboardPwdId' => $keyboardPwdId,
            'deleteType' => 2,
            'date' => now()->timestamp * 1000,
        ];

        $response = Http::timeout(7200)->asForm()->post($this->baseUrl . 'v3/keyboardPwd/delete', $params);

        return $response->json();

        Log::info('Deleted Passcode');
    }

    /* Delete Expired Card Function  */

    public function delete_Card($accessToken, $lockId, $cardID)
    {
        $params = [
            // Parameters as required by the API
            'clientId' => $this->clientId,
            'accessToken' => $accessToken,
            'lockId' => $lockId,
            'cardId' => $cardID,
            'deleteType' => 2,
            'date' => now()->timestamp * 1000,
        ];

        $response = Http::asForm()->post($this->baseUrl . 'v3/identityCard/delete', $params);

        return $response->json();
    }

    /* Delete Expired Card Function Ends here */

    public function sendPasscode_for_booking($lockId, $bookingID, $guestName, $roomID, $unitName, $timestamp_startDate, $timestampt_endDate, $propertyID)
    {

        $milliseconds = time() * 1000;

        $custom_passcode = substr($bookingID, -4);
        $passcode = urlencode($custom_passcode);
        $guestName = $guestName;


        // Get Door Time hours from DB using the Current Property ID

        // Code to get Sciener AccessToken for the property

        $scienerDetails = ScienerDetails::where('PropertyID', $propertyID)->first();

        if ($scienerDetails) {
            $username = $scienerDetails->username;
            $password = $scienerDetails->password;
            $accessToken = $scienerDetails->token;
            $refresh_token = $scienerDetails->refresh_token;

            log::info('sending code for lock Id : ' . $lockId);

            // Request to send Passcode to lock


            $response = Http::timeout(1000)->asForm()->post($this->baseUrl . "v3/keyboardPwd/add", [
                'clientId' => $this->clientId,
                'accessToken' => $accessToken,
                'lockId' => $lockId,
                'keyboardPwd' => $passcode,
                'keyboardPwdName' => $guestName,
                'startDate' => $timestamp_startDate,
                'endDate' => $timestampt_endDate,
                'addType' => 2,
                'date' => $milliseconds
            ]);

            if ($response->successful()) {
                $result = $response->json();
                LOG::info($response);

                if (isset($response['errcode']) && $response['errcode'] == -3007) {

                    $this->refresh_ScienerToken($refresh_token);

                    $scienerDetails = ScienerDetails::where('PropertyID', $propertyID)->first();

                    if ($scienerDetails) {
                        $username = $scienerDetails->username;
                        $password = $scienerDetails->password;
                        $accessToken = $scienerDetails->token;
                        $refresh_token = $scienerDetails->refresh_token;

                        $response = Http::timeout(1000)->asForm()->post($this->baseUrl . "v3/keyboardPwd/add", [
                            'clientId' => $this->clientId,
                            'accessToken' => $accessToken,
                            'lockId' => $lockId,
                            'keyboardPwd' => $passcode,
                            'keyboardPwdName' => $guestName,
                            'startDate' => $timestamp_startDate,
                            'endDate' => $timestampt_endDate,
                            'addType' => 2,
                            'date' => $milliseconds
                        ]);

                        if ($response->successful()) {
                            return $response;
                        }
                    }
                }

                return $response;
                // Process the response
            } else {
                // Handle the error
                $error = $response->body();
                return $response;
            }
        } else {
            //  dump('Sciener details are not added. Kindly fetch locks First');
        }
    }



    public function add_staff_passcode($Staff, $lockId)
    {

        $staffId = $Staff->id;
        $propertyId = $Staff->property_id;
        $roleId = $Staff->role_id;
        $name = $Staff->name;
        $email = $Staff->email;
        $phone = $Staff->phone;
        $licensePlate = $Staff->license_plate;
        $photoPath = $Staff->photo_path;
        $passcode = $Staff->passcode;
        $cardNumber = $Staff->card_number;

        $milliseconds = time() * 1000;


        // Replace with your actual data
        $clientId = $this->clientId;

        $keyboardPwdName = $name;
        $addType = 2;
        $date = $milliseconds;
        $startDate = 0;
        $endDate = 0;

        $scienerDetails = ScienerDetails::where('PropertyID', $propertyId)->first();


        if ($scienerDetails) {
            log::info($lockId);

            $username = $scienerDetails->username;
            $password = $scienerDetails->password;
            $accessToken = $scienerDetails->token;
            $refresh_token = $scienerDetails->refresh_token;

            // Prepare the data
            $data = [
                'clientId' => $clientId,
                'accessToken' => $accessToken,
                'lockId' => $lockId,
                'keyboardPwd' => $passcode,
                'keyboardPwdName' => $keyboardPwdName,
                'startDate' => $milliseconds,
                'endDate', 0,
                'addType' => $addType,
                'date' => $date,
            ];

            // Send the POST request
            $response = Http::asForm()->post('https://api.sciener.com/v3/keyboardPwd/add', $data);

            // Handle the response
            if ($response->successful()) {
                // Process the successful response
                log::info($response);
                session()->flash('message', 'Request was successful');
                return $response;
            } else {
                // Handle the error response
                session()->flash('error', 'Request failed: ' . $response->body());
            }
        }
    }

    public function make_staff_card($staff, $lockIdValue)
    {

        $staffId = $staff->id;
        $propertyId = $staff->property_id;
        $roleId = $staff->role_id;
        $name = $staff->name;
        $email = $staff->email;
        $phone = $staff->phone;
        $licensePlate = $staff->license_plate;
        $photoPath = $staff->photo_path;
        $passcode = $staff->passcode;
        $cardNumber = $staff->card_number;

        $milliseconds = time() * 1000;


        // Replace with your actual data
        $clientId = $this->clientId;

        $keyboardPwdName = $name;
        $addType = 2;
        $date = $milliseconds;
        $startDate = 0;
        $endDate = 0;

        $scienerDetails = ScienerDetails::where('PropertyID', $propertyId)->first();


        if ($scienerDetails) {


            $username = $scienerDetails->username;
            $password = $scienerDetails->password;
            $accessToken = $scienerDetails->token;
            $refresh_token = $scienerDetails->refresh_token;


            $response = Http::asForm()->post('https://euapi.sciener.com/v3/identityCard/addForReversedCardNumber', [
                'clientId' => $clientId,
                'accessToken' => $accessToken,
                'lockId' => $lockIdValue,
                'cardNumber' => $cardNumber,
                'cardName' => $keyboardPwdName,
                'startDate' => 0,
                'endDate' => 0,
                'addType' => '2',
                'date' => $milliseconds,
            ]);

            log::info($response);

            if ($response->successful()) {
                // Handle successful response

                return response()->json(['message' => 'Card added successfully', 'data' => $response->json()]);
            } else {
                // Handle error response
                return response()->json(['error' => 'Request failed', 'data' => $response->body()], $response->status());
            }
        }
    }


    /* Adding permanent codes for staff ends here  */

    public function send_golf_passcode($lockId, $passcode, $guestName, $startDate, $bookingendDate, $propertyID)
    {

        $milliseconds = time() * 1000;

        // Get Door Time hours from DB using the Current Property ID

        // Code to get Sciener AccessToken for the property

        $scienerDetails = ScienerDetails::where('PropertyID', $propertyID)->first();

        if ($scienerDetails) {
            $username = $scienerDetails->username;
            $password = $scienerDetails->password;
            $accessToken = $scienerDetails->token;
            $refresh_token = $scienerDetails->refresh_token;



            // Request to send Passcode to lock


            $response = Http::timeout(1000)->asForm()->post($this->baseUrl . "v3/keyboardPwd/add", [
                'clientId' => $this->clientId,
                'accessToken' => $accessToken,
                'lockId' => $lockId,
                'keyboardPwd' => $passcode,
                'keyboardPwdName' => $guestName,
                'startDate' => $startDate,
                'endDate' => $bookingendDate,
                'addType' => 2,
                'date' => $milliseconds
            ]);

            if ($response->successful()) {
                $result = $response->json();
                return $response;


                // Process the response
            } else {
                // Handle the error
                $error = $response->body();
                return $response;
            }
        } else {
            //  dump('Sciener details are not added. Kindly fetch locks First');
        }
    }

    /*  Send Passcode for golf properties end here */
    public function generateRandomPasscode($accessToken, $lockId, $keyboardPwdType, $keyboardPwdName, $startDate, $endDate, $cyclicConfig = [])
    {
        $params = [
            'clientId' => $this->clientId,
            'accessToken' => $accessToken,
            'lockId' => $lockId,
            'keyboardPwdType' => $keyboardPwdType,
            'keyboardPwdName' => $keyboardPwdName,
            'startDate' => $startDate,
            'endDate' => $endDate,
            'date' => now()->timestamp * 1000
        ];

        if (!empty($cyclicConfig)) {
            $params['cyclicConfig'] = json_encode($cyclicConfig);
        }

        $response = Http::asForm()->post($this->baseUrl . 'v3/keyboardPwd/get', $params);
        return $response->json();
    }

    public function sendPasscode($accessToken, $lockId, $keyboardPwd, $keyboardPwdName, $startDate, $endDate, $keyboardPwdType)
    {


        $response = Http::timeout(1000)->asForm()->post($this->baseUrl . "v3/keyboardPwd/add", [
            'clientId' => $this->clientId,
            'accessToken' => $accessToken,
            'lockId' => $lockId,
            'keyboardPwd' => $keyboardPwd,
            'keyboardPwdName' => $keyboardPwdName,
            'startDate' => $startDate,
            'endDate' => $endDate,
            'addType' => 2,
            'date' => time() * 1000
        ]);

        if ($response->successful()) {
            $result = $response->json();
            return $response;


            // Process the response
        } else {
            // Handle the error
            $error = $response->body();
            return $response;
        }
        return $response->json();
    }

    /* sending passcode for modified early check in  */

    public function modify_passcode($accessToken, $lockId, $custom_passcode, $guestName, $milliseconds, $timestampt_endDate, $keyboardPwdId)
    {
        $response = Http::timeout(1000)->asForm()->post($this->baseUrl . "v3/keyboardPwd/change", [
            'clientId' => $this->clientId,
            'accessToken' => $accessToken,
            'lockId' => $lockId,
            'keyboardPwdId' => $keyboardPwdId,
            'keyboardPwdName' => $guestName,
            'newKeyboardPwd' => $custom_passcode,
            'startDate' => $milliseconds,
            'endDate' => $timestampt_endDate,
            'changeType' => 2,
            'date' => time() * 1000
        ]);

        if ($response->successful()) {
            $result = $response->json();
            return $response;


            // Process the response
        } else {
            // Handle the error
            $error = $response->body();
            return $response;
        }
        return $response->json();
    }

    /* sending passcode for modified early check in  */
    public function listEkeysOfLock($accessToken, $lockId)
    {
        $params = [
            'clientId' => $this->clientId,
            'accessToken' => $accessToken,
            'lockId' => $lockId,
            'pageNo' => 1,
            'pageSize' => 100,
            'date' => now()->timestamp * 1000
        ];

        $response = Http::get($this->baseUrl . 'v3/lock/listKey', $params);
        return $response->json();
    }

    public function listCardsOfLock($accessToken, $lockId)
    {
        $params = [
            'clientId' => $this->clientId,
            'accessToken' => $accessToken,
            'lockId' => $lockId,
            'pageNo' => 1,
            'pageSize' => 100,
            'date' => now()->timestamp * 1000
        ];

        $response = Http::get($this->baseUrl . 'v3/identityCard/list', $params);
        return $response->json();
    }

    public function addCardToLock($propertyID, $lockID, $GuestName, $timestamp_startDate, $timestamp_endDate, $cardNumber, $bookingID)
    {

        $scienerDetails = ScienerDetails::where('PropertyID', $propertyID)->first();
        //  echo "Hello this is add card function in sciener api service";
        if ($scienerDetails) {
            $username = $scienerDetails->username;
            $password = $scienerDetails->password;
            $accessToken = $scienerDetails->token;
            $refresh_token = $scienerDetails->refresh_token;

            $url = 'https://euapi.sciener.com/v3/identityCard/addForReversedCardNumber';

            // Create an associative array with the POST data
            $postData = [
                'clientId' => 'f0fa1635cb8c4b3694553e48267afe75',
                'accessToken' => $accessToken, // Assuming getAdminToken() is a method that fetches the accessToken
                'lockId' => $lockID,
                'cardNumber' => $cardNumber,
                'cardName' => $GuestName,
                'startDate' => $timestamp_startDate,
                'endDate' => $timestamp_endDate,
                'addType' => '2',
                'date' => now()->timestamp * 1000
            ];

            // Make the POST request using Laravel's HTTP client
            $response = Http::asForm()->post($url, $postData);

            return $response;
        }
    }
}
